/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.radio;

import it.inaf.ia2.query.SortInfo;
import it.inaf.ia2.query.builder.ListQueryBuilder;
import it.inaf.ia2.query.builder.QueryBuilder;
import it.inaf.ia2.query.radio.RadioQueryBuilder;
import it.inaf.ia2.query.radio.Tab;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RadioListQueryBuilder
extends RadioQueryBuilder
implements ListQueryBuilder {
    public RadioListQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    public QueryBuilder buildQuery() {
        this.append("SELECT");
        switch (this.getTab()) {
            case PULSAR: {
                this.appendTopAndOffset();
                this.appendSelectList();
                this.append("FROM pulsar.pulsar");
                this.appendWhere();
                break;
            }
            default: {
                this.appendSelectList();
                this.append("FROM (");
                this.appendInnerQuery();
                this.append(") AS fi_inner");
                if (this.getTab() == Tab.SIMPLE) {
                    this.append("JOIN \"all\".radio a ON fi_inner.file_name = a.file_name");
                } else {
                    this.append("JOIN radio.file_info fi ON fi_inner.file_name = fi.file_name");
                }
                this.appendJoins();
            }
        }
        this.appendSort();
        return this;
    }

    private void appendInnerQuery() {
        this.append("SELECT DISTINCT");
        this.appendTopAndOffset();
        if (this.getTab() == Tab.SIMPLE) {
            this.append("file_name FROM \"all\".radio a");
        } else {
            this.append("fi.file_name FROM radio.file_info fi");
            this.appendJoins();
        }
        this.appendWhere();
    }

    protected void appendSelectList() {
        if (this.getTab() == Tab.PULSAR) {
            this.addToSelect("file_name");
            this.addToSelect("url", "file_url");
            this.addToSelect("policy", "policy");
            this.addToSelect("projid", "program");
            if (this.getBool("ra_sel")) {
                this.addToSelect("RA_C", "ra_char");
            }
            if (this.getBool("dec_sel")) {
                this.addToSelect("DEC_C", "dec_char");
            }
            this.conditionalAddToSelect("telescope");
            this.conditionalAddToSelect("obs_mode");
            this.conditionalAddToSelect("backend");
            this.conditionalAddToSelect("observer");
            this.conditionalAddToSelect("date_obs");
        } else {
            if (this.getTab() == Tab.SIMPLE) {
                this.addToSelect("a.file_name", "file_name");
                this.addToSelect("a.file_url", "file_url");
                this.addToSelect("a.type", "type");
                this.addToSelect("a.policy", "policy");
                this.addToSelect("a.program", "program");
                if (this.getBool("ra_sel")) {
                    this.addToSelect("a.ra_char", "ra_char");
                }
                if (this.getBool("dec_sel")) {
                    this.addToSelect("a.dec_char", "dec_char");
                }
                this.conditionalAddToSelect("a.date_obs", "date_obs");
                if (this.getBool("freq_sel")) {
                    this.addToSelect("a.min_freq", "min_freq");
                    this.addToSelect("a.max_freq", "max_freq");
                }
            } else {
                this.addToSelect("fi.file_name", "file_name");
                this.addToSelect("fi.file_url", "file_url");
                this.addToSelect("fi.policy", "policy");
                this.addToSelect("df.projid", "program");
                if (this.getBool("ra_sel")) {
                    this.addToSelect("df.ra_char", "ra_char");
                }
                if (this.getBool("dec_sel")) {
                    this.addToSelect("df.dec_char", "dec_char");
                }
                this.conditionalAddToSelect("df.dateobs", "dateobs");
                if (this.getBool("freq_sel")) {
                    this.addToSelect("ad.min_freq", "min_freq");
                    this.addToSelect("ad.max_freq", "max_freq");
                }
            }
            switch (this.getTab()) {
                case VLBI: {
                    this.appendVLBISelectList();
                    break;
                }
                case SD: {
                    this.appendSDSelectList();
                }
            }
        }
        super.appendSelectList();
    }

    private void appendVLBISelectList() {
        this.addToSelect("df.object", "object");
        this.conditionalAddToSelect("df.piname", "piname");
        this.conditionalAddToSelect("df.telescop", "telescop");
        this.conditionalAddToSelect("df.exptime", "exptime");
        this.conditionalAddToSelect("df.antennas", "antennas");
        this.conditionalAddToSelect("df.rate", "rate");
        this.conditionalAddToSelect("df.channels_vlbi", "channels");
        this.conditionalAddToSelect("df.ch_resol", "ch_resol");
    }

    private void appendSDSelectList() {
        this.conditionalAddToSelect("df.telescop", "telescop");
        this.conditionalAddToSelect("fe.frontend", "frontend");
        this.conditionalAddToSelect("fe.backend", "backend");
        this.conditionalAddToSelect("ad.bandwid", "bandwid");
        this.conditionalAddToSelect("df.equinox", "equinox");
        this.conditionalAddToSelect("df.exptime", "exptime");
        this.conditionalAddToSelect("df.lst", "lst");
        this.conditionalAddToSelect("df.scantype", "scantype");
        this.conditionalAddToSelect("df.scanmode", "scanmode");
        this.conditionalAddToSelect("df.scangeom", "scangeom");
        this.conditionalAddToSelect("ss.usrframe", "usrframe");
        this.conditionalAddToSelect("df.scanxvel", "scanxvel");
        this.conditionalAddToSelect("fe.swtchmod", "swtchmod");
        this.conditionalAddToSelect("ad.freqres", "freqres");
        this.conditionalAddToSelect("ad.restfreq", "restfreq");
        this.conditionalAddToSelect("bb.freq_bin", "freq_bin");
        this.conditionalAddToSelect("df.wobused", "wobused");
        this.conditionalAddToSelect("df.obsid", "obsid");
        this.conditionalAddToSelect("df.creator", "creator");
        this.conditionalAddToSelect("df.fitsver", "fitsver");
        this.addToSelect("s.file_name", "schedule_name");
        this.addToSelect("s.file_url", "schedule_url");
    }

    private String getFileNameSorting(List<SortInfo> sortInfos) {
        return sortInfos.stream().filter(si -> si.getColumnName().equals("file_name")).map(fi -> fi.getSort()).findFirst().orElse("ASC");
    }

    protected void appendSort() {
        List sortInfos;
        ArrayList<Object> sorts = new ArrayList<Object>();
        if (this.has("sort") && (sortInfos = (List)this.get("sort", List.class)) != null && !sortInfos.isEmpty()) {
            sorts.add("file_name " + this.getFileNameSorting(sortInfos));
            sortInfos.forEach(sortInfo -> {
                if (!sortInfo.getColumnName().equals("file_name")) {
                    sorts.add(String.format("%s %s", sortInfo.getColumnName(), sortInfo.getSort()));
                }
            });
        } else {
            sorts.add("file_name ASC");
        }
        this.append("ORDER BY");
        this.appendList(sorts, ", ");
    }
}

