/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.radio;

import it.inaf.ia2.query.builder.BaseQueryBuilder;
import it.inaf.ia2.query.radio.Tab;
import it.inaf.ia2.query.util.RADecConverter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class RadioQueryBuilder
extends BaseQueryBuilder {
    private boolean joinArraydata;
    private boolean joinBaseband;
    private boolean joinFebe;
    private boolean joinSubscan;

    public RadioQueryBuilder(Map<String, Object> params) {
        super(params);
        this.checkTablesToJoin();
    }

    private void checkTablesToJoin() {
        this.joinArraydata = this.hasToJoinArraydata();
        this.joinBaseband = this.hasToJoinBaseband();
        this.joinFebe = this.hasToJoinFebe();
        this.joinSubscan = this.hasToJoinSubscan();
    }

    private boolean hasToJoinArraydata() {
        return this.checkSimpleFields("channels", "freqres", "restfreq", "bandwid") || this.getBool("freq_sel") || this.has("freq_min") || this.has("freq_max");
    }

    private boolean hasToJoinBaseband() {
        return this.checkSimpleFields("baseband", "freq_bin");
    }

    private boolean hasToJoinFebe() {
        if (this.joinBaseband) {
            return true;
        }
        return this.checkSimpleFields("frontend", "backend", "swtchmod");
    }

    private boolean hasToJoinSubscan() {
        return this.checkSimpleFields("usrframe");
    }

    private boolean checkSimpleFields(String ... keys) {
        for (String key : keys) {
            if (!this.getBool(key + "_sel") && !this.has(key)) continue;
            return true;
        }
        return false;
    }

    protected Tab getTab() {
        String tab;
        switch (tab = (String)this.get("tab", String.class)) {
            case "simple": {
                return Tab.SIMPLE;
            }
            case "vlbi": {
                return Tab.VLBI;
            }
            case "sd": {
                return Tab.SD;
            }
            case "pulsar": {
                return Tab.PULSAR;
            }
        }
        throw new UnsupportedOperationException("Invalid tab: " + tab);
    }

    protected void appendJoins() {
        if (this.getTab() == Tab.PULSAR) {
            return;
        }
        this.append("LEFT JOIN data_file df ON fi.file_info_id = df.file_info_id");
        if (this.joinArraydata) {
            this.append("LEFT JOIN arraydata ad ON df.data_file_id = ad.data_file_id");
        }
        if (this.joinFebe) {
            this.append("LEFT JOIN febe fe ON fe.data_file_id = df.data_file_id");
        }
        if (this.joinBaseband) {
            this.append("LEFT JOIN baseband bb ON bb.febe_id = fe.febe_id");
        }
        if (this.joinSubscan) {
            this.append("LEFT JOIN subscan ss ON ss.data_file_id = df.data_file_id");
        }
    }

    protected void appendWhere() {
        if (this.getTab() == Tab.PULSAR) {
            this.addLikeCondition("file_name", false, true);
            this.addCondition("obs_mode", "=");
            this.addCondition("telescope", "=");
            this.addLikeCondition("projid", "program", false, true);
            this.addLikeCondition("backend", true, true);
            this.addLikeCondition("observer", true, true);
            this.addCondition("date_obs", ">=", "date_obs_min");
            this.addCondition("date_obs", "<=", "date_obs_max");
        } else {
            this.addLikeCondition("fi.file_name", "file_name", false, true);
            this.addRangeCondition("df.dateobs", "dateobs");
            this.addProgramCondition();
            this.addLikeCondition("df.projid", "program", false, true);
            this.addRangeCondition("freq");
            switch (this.getTab()) {
                case VLBI: {
                    this.appendVLBIWhere();
                    break;
                }
                case SD: {
                    this.appendSDWhere();
                }
            }
        }
        this.addPositionalSearch();
        super.appendWhere();
    }

    private void addPositionalSearch() {
        if (this.has("ra") && this.has("dec") && this.has("radius")) {
            String raChar = (String)this.get("ra", String.class);
            String decChar = (String)this.get("dec", String.class);
            double radius = this.getDouble("radius");
            if (radius > 0.0) {
                double ra = RADecConverter.getRADegrees((String)raChar);
                double dec = RADecConverter.getDecDegrees((String)decChar);
                if (this.getTab() == Tab.PULSAR) {
                    String pointCond = String.format("1=CONTAINS(s_point, CIRCLE('ICRS',%s,%s,%s/60))", ra, dec, radius);
                    this.addToWhere(pointCond);
                } else {
                    String pointCond = String.format("s_region IS NULL AND 1=CONTAINS(s_point, CIRCLE('ICRS',%s,%s,%s/60))", ra, dec, radius);
                    String regionCond = String.format("s_region IS NOT NULL AND 1=INTERSECTS(s_region, CIRCLE('ICRS',%s,%s,%s/60))", ra, dec, radius);
                    this.addToWhere(String.format("((%s) OR (%s))", pointCond, regionCond));
                }
            }
        }
    }

    private void appendVLBIWhere() {
        this.addToWhere("fi.data_type = 'xml'");
        this.addLikeCondition("df.piname", "piname", false, true);
        this.addCondition("df.telescop", "=", "telescop");
        this.addCondition("df.exptime", "=", "exptime");
        this.addAntennasCondition();
        this.addCondition("df.rate", "=", "exptime");
        this.addCondition("ad.channels", "=", "channels");
        this.addCondition("df.ch_resol", "=", "ch_resol");
    }

    private void addAntennasCondition() {
        List antennas;
        if (this.has("antennas") && !(antennas = (List)this.get("antennas", List.class)).isEmpty()) {
            ArrayList<CallSite> antennaConditions = new ArrayList<CallSite>();
            for (String antenna : antennas) {
                antennaConditions.add((CallSite)((Object)("df.antennas LIKE '%" + this.sanitizeForLike(antenna) + "%'")));
            }
            this.addToWhere(String.join((CharSequence)" AND ", antennaConditions));
        }
    }

    private void appendSDWhere() {
        this.addToWhere("fi.data_type = 'fits'");
        this.addCondition("df.telescop", "=", "telescop");
        this.addCondition("fe.frontend", "=", "frontend");
        this.addCondition("fe.backend", "=", "backend");
        this.addCondition("ad.bandwid", "=", "bandwid");
        this.addCondition("df.equinox", "=", "equinox");
        this.addCondition("df.exptime", "=", "exptime");
        this.addRangeCondition("df.lst", "lst");
        this.addCondition("df.scantype", "=", "scantype");
        this.addCondition("df.scanmode", "=", "scanmode");
        this.addCondition("df.scangeom", "=", "scangeom");
        this.addCondition("ss.usrframe", "=", "usrframe");
        this.addCondition("df.scanxvel", "=", "scanxvel");
        this.addCondition("df.swtchmod", "=", "swtchmod");
        this.addCondition("ad.freqres", "=", "freqres");
        this.addCondition("ad.restfreq", "=", "restfreq");
        this.addCondition("bb.freq_bin", "=", "freq_bin");
        this.addCondition("df.wobused", "=", "wobused");
        this.addLikeCondition("df.obsid", "obsid", true, true);
        this.addLikeCondition("df.creator", "creator", true, true);
        this.addLikeCondition("df.fitsver", "fitsver", true, true);
    }

    private void addProgramCondition() {
        List groups;
        if (this.has("user_groups") && !this.has("program") && !(groups = (List)this.get("user_groups", List.class)).isEmpty()) {
            this.addToWhere("df.projid IN(" + this.getSafeParamList(groups) + ")");
        }
    }
}

