/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.executor;

import it.inaf.ia2.query.builder.QueryBuilder;
import it.inaf.ia2.query.conf.PortalConfig;
import it.inaf.ia2.query.exception.QueryExecutionException;
import it.inaf.ia2.tapclient.TAPClient;
import it.inaf.ia2.tapclient.TAPServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProxyQueryExecutor {
    private static final int BUFFER_SIZE = 102400;
    private final QueryBuilder queryBuilder;
    private final TAPClient tapClient;

    public ProxyQueryExecutor(PortalConfig portalConfig, TAPClient tapClient, QueryBuilder listQueryBuilder) {
        this.queryBuilder = listQueryBuilder;
        this.tapClient = tapClient;
    }

    public void execute(OutputStream out, String mediaType) throws TAPServiceException, IOException {
        String sqlQuery = this.queryBuilder.buildQuery().get();
        try (InputStream in = this.tapClient.query(sqlQuery, mediaType);){
            int len;
            byte[] buffer = new byte[102400];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (Throwable t) {
            throw new QueryExecutionException(t, sqlQuery);
        }
    }
}

