/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.executor;

import it.inaf.ia2.query.builder.QueryBuilder;
import it.inaf.ia2.query.conf.PortalConfig;
import it.inaf.ia2.query.exception.QueryExecutionException;
import it.inaf.ia2.query.result.CountQueryResultsParser;
import it.inaf.ia2.tapclient.TAPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountQueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CountQueryExecutor.class);
    private final QueryBuilder countQueryBuilder;
    private final TAPClient tapClient;

    public CountQueryExecutor(PortalConfig portalConfig, TAPClient tapClient, QueryBuilder countQueryBuilder) {
        this.countQueryBuilder = countQueryBuilder;
        this.tapClient = tapClient;
    }

    public long execute() {
        String countQuery = null;
        try {
            countQuery = this.countQueryBuilder.buildQuery().get();
            LOG.debug("Count Query " + countQuery);
            CountQueryResultsParser countParser = new CountQueryResultsParser(this.tapClient, countQuery);
            countParser.parseQuery();
            return countParser.getCount();
        }
        catch (Throwable t) {
            throw new QueryExecutionException(t, countQuery);
        }
    }
}

