/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.builder;

import it.inaf.ia2.query.builder.BaseQueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class DefaultQueryBuilder
extends BaseQueryBuilder {
    protected static final List<String> KEYWORDS_TO_IGNORE = Collections.unmodifiableList(Arrays.asList("top", "offset", "tab", "secondary_tab", "sort", "total_count", "user_groups", "radius", "ra", "dec"));
    private final Set<String> usedKeys = new HashSet<String>();

    protected static List<String> createKeywordsToIgnoreList(String ... keys) {
        ArrayList<String> keywordsToIgnore = new ArrayList<String>(KEYWORDS_TO_IGNORE);
        keywordsToIgnore.addAll(Arrays.asList(keys));
        return Collections.unmodifiableList(keywordsToIgnore);
    }

    public DefaultQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    @Override
    protected void addCondition(String column, String operator, String key, Function paramTransf) {
        this.usedKeys.add(key);
        super.addCondition(column, operator, key, paramTransf);
    }

    @Override
    protected void addLikeCondition(String column, String key, boolean wildCardBefore, boolean wildCardAfter) {
        this.usedKeys.add(key);
        super.addLikeCondition(column, key, wildCardBefore, wildCardAfter);
    }

    protected void addUsedKey(String key) {
        this.usedKeys.add(key);
    }

    protected String getFullColumnName(String columnKey) {
        return "\"" + columnKey + "\"";
    }

    protected List<String> getKeywordsToIgnore() {
        return KEYWORDS_TO_IGNORE;
    }

    private String removePart(String value, String partToRemove) {
        return value.substring(0, value.length() - partToRemove.length());
    }

    @Override
    protected void appendWhere() {
        this.getParams().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!this.getKeywordsToIgnore().contains(key) && !key.endsWith("_sel")) {
                if (key.endsWith("_min")) {
                    String baseKey = this.removePart(key, "_min");
                    if (!this.usedKeys.contains(baseKey)) {
                        this.addCondition(this.getFullColumnName(baseKey), ">=", key);
                    }
                } else if (key.endsWith("_max")) {
                    String baseKey = this.removePart(key, "_max");
                    if (!this.usedKeys.contains(baseKey)) {
                        this.addCondition(this.getFullColumnName(baseKey), "<=", key);
                    }
                } else if (!this.usedKeys.contains(key)) {
                    this.addCondition(this.getFullColumnName(key), "=", key);
                }
            }
        });
        super.appendWhere();
    }

    @Override
    protected void appendSelectList() {
        this.getParams().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!this.getKeywordsToIgnore().contains(key) && key.endsWith("_sel") && this.getBool(key)) {
                String fullColumnName;
                String columnKey = this.removePart(key, "_sel");
                if (columnKey.equals(fullColumnName = this.getFullColumnName(columnKey))) {
                    this.addToSelect("\"" + columnKey + "\"");
                } else {
                    this.addToSelect(fullColumnName, columnKey);
                }
            }
        });
        super.appendSelectList();
    }
}

