/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.result;

import it.inaf.ia2.query.result.CountQueryResultsParser;
import it.inaf.ia2.query.result.QueryResult;
import it.inaf.ia2.query.result.QueryResultBuilderParams;
import it.inaf.ia2.tapclient.QueryResultsParser;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryResultBuilder<T extends QueryResult> {
    private static final Logger LOG = LoggerFactory.getLogger(QueryResultBuilder.class);
    protected final QueryResultBuilderParams params;

    public QueryResultBuilder(QueryResultBuilderParams params) {
        this.params = params;
    }

    protected abstract T getQueryResult();

    protected abstract QueryResultsParser getQueryResultsParser();

    public T buildResult() {
        T queryResult = this.getQueryResult();
        ((QueryResult)queryResult).setColumns(this.params.getOutColumns());
        ((QueryResult)queryResult).setQuery(this.params.getQueryList());
        this.writeRowsAndCount();
        return queryResult;
    }

    private void writeRowsAndCount() {
        QueryResultsParser listParser = this.getQueryResultsParser();
        CountQueryResultsParser countParser = new CountQueryResultsParser(this.params.getTapClient(), this.params.getQueryCount());
        CompletableFuture.allOf(listParser.parseQueryRx(), countParser.parseQueryRx()).join();
        ((QueryResult)this.getQueryResult()).setTotalCount(countParser.getCount());
    }
}

