/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.result;

import it.inaf.ia2.query.result.CompositeQueryResult;
import it.inaf.ia2.query.result.QueryResultBuilder;
import it.inaf.ia2.query.result.QueryResultBuilderParams;
import it.inaf.ia2.tapclient.QueryResultsParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultBuilderComposite
extends QueryResultBuilder<CompositeQueryResult> {
    private static final Logger LOG = LoggerFactory.getLogger(QueryResultBuilderComposite.class);
    private final Set<Integer> rowspanColumnsPos;
    private final int compositeIndexPos;
    private String currentCompositeRowIndex;
    private List<List<Object>> compositeRow;
    private final CompositeQueryResult queryResult = new CompositeQueryResult();

    public QueryResultBuilderComposite(QueryResultBuilderParams params, Set<String> rowspanColumns, String compositeRowIndexName) {
        super(params);
        HashMap<String, Integer> rowspanColumnsPosMap = new HashMap<String, Integer>();
        for (int i = 0; i < params.getOutColumns().size(); ++i) {
            String columnName = params.getOutColumns().get(i);
            if (!rowspanColumns.contains(columnName)) continue;
            rowspanColumnsPosMap.put(columnName, i);
        }
        this.rowspanColumnsPos = new HashSet(rowspanColumnsPosMap.values());
        this.compositeIndexPos = (Integer)rowspanColumnsPosMap.get(compositeRowIndexName);
        this.queryResult.setRowspanColumns(this.rowspanColumnsPos);
    }

    @Override
    public CompositeQueryResult getQueryResult() {
        return this.queryResult;
    }

    private void addCompositeRow() {
        List<List<Object>> rows = this.queryResult.getRows();
        rows.add(this.compositeRowToSimpleList());
    }

    private List<Object> compositeRowToSimpleList() {
        ArrayList<Object> list = new ArrayList<Object>();
        this.compositeRow.forEach(subRow -> list.add(subRow));
        return list;
    }

    @Override
    public CompositeQueryResult buildResult() {
        CompositeQueryResult result = (CompositeQueryResult)super.buildResult();
        if (this.compositeRow != null) {
            this.addCompositeRow();
        }
        return result;
    }

    @Override
    protected QueryResultsParser getQueryResultsParser() {
        return new QueryResultsParser(this.params.getTapClient(), this.params.getQueryList()){

            public void readMetadataItem(Map<String, Object> rowItem) {
            }

            public void readDataRow(List<Object> rowItems) {
                String previousPrimaryRowIndex = QueryResultBuilderComposite.this.currentCompositeRowIndex;
                QueryResultBuilderComposite.this.currentCompositeRowIndex = (String)rowItems.get(QueryResultBuilderComposite.this.compositeIndexPos);
                if (!QueryResultBuilderComposite.this.currentCompositeRowIndex.equals(previousPrimaryRowIndex)) {
                    if (QueryResultBuilderComposite.this.compositeRow != null) {
                        QueryResultBuilderComposite.this.addCompositeRow();
                    }
                    QueryResultBuilderComposite.this.compositeRow = new ArrayList<List<Object>>();
                }
                QueryResultBuilderComposite.this.addItemsToCompositeRow(rowItems);
            }
        };
    }

    private void addItemsToCompositeRow(List<Object> rowItems) {
        ArrayList<Object> subrow = new ArrayList<Object>();
        this.compositeRow.add(subrow);
        for (int i = 0; i < rowItems.size(); ++i) {
            subrow.add(rowItems.get(i));
        }
    }
}

