/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.validator;

import it.inaf.ia2.query.validator.ParametersValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class BaseParametersValidator
implements ParametersValidator {
    private static final String RA = "ra";
    private static final String DEC = "dec";
    private final Map<String, Object> params;
    private final Map<String, String> errors = new HashMap<String, String>();

    public BaseParametersValidator(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public final Optional<Map<String, String>> validateParameters() {
        if (this.params.containsKey(RA)) {
            this.validateRA((String)this.params.get(RA));
        }
        if (this.params.containsKey(DEC)) {
            this.validateDec((String)this.params.get(DEC));
        }
        this.validateSpecificParameters();
        if (this.errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.errors);
    }

    protected abstract void validateSpecificParameters();

    private void validateRA(String value) {
        boolean valid = true;
        String[] splitted = value.split(":");
        if (splitted.length != 3) {
            valid = false;
        } else {
            try {
                double seconds;
                int minutes;
                int hours = Integer.parseInt(splitted[0]);
                if (hours < 0 || hours > 23) {
                    valid = false;
                }
                if ((minutes = Integer.parseInt(splitted[1])) < 0 || minutes > 59) {
                    valid = false;
                }
                if ((seconds = Double.parseDouble(splitted[2])) < 0.0 || seconds >= 60.0) {
                    valid = false;
                }
            }
            catch (NumberFormatException e) {
                valid = false;
            }
        }
        if (!valid) {
            this.addError(RA, "Invalid RA format. Should be hh:mm:ss.ss");
        }
    }

    private void validateDec(String value) {
        boolean valid = true;
        String[] splitted = value.split(":");
        if (splitted.length != 3) {
            valid = false;
        } else {
            try {
                double seconds;
                int minutes;
                int deg = Integer.parseInt(splitted[0]);
                if (deg < -90 || deg > 90) {
                    valid = false;
                }
                if ((minutes = Integer.parseInt(splitted[1])) < 0 || minutes > 59) {
                    valid = false;
                }
                if ((seconds = Double.parseDouble(splitted[2])) < 0.0 || seconds >= 60.0) {
                    valid = false;
                }
            }
            catch (NumberFormatException e) {
                valid = false;
            }
        }
        if (!valid) {
            this.addError(DEC, "Invalid Dec format. Should be dd:mm:ss.ss");
        }
    }

    protected void validateDate(String key) {
        this.validateDateUsingFormat(key, "yyyy-MM-dd");
    }

    protected void validateDateTime(String key) {
        this.validateDateUsingFormat(key, "yyyy-MM-dd HH:mm");
    }

    private void validateDateUsingFormat(String key, String format) {
        Object value;
        if (this.params.containsKey(key) && (value = this.params.get(key)) instanceof String) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                Date date = sdf.parse((String)value);
                this.params.put(key, date);
            }
            catch (ParseException ex) {
                this.addError(key, "Invalid date format. Should be " + format);
            }
        }
    }

    protected void validateDouble(String key) {
        if (this.params.containsKey(key)) {
            Object value = this.params.get(key);
            if (value instanceof Integer) {
                this.params.put(key, ((Integer)value).doubleValue());
            } else if (value instanceof String) {
                try {
                    double number = Double.parseDouble((String)value);
                    this.params.put(key, number);
                }
                catch (NumberFormatException ex) {
                    this.addError(key, "Should be a number");
                }
            }
        }
    }

    protected void addError(String key, String error) {
        this.errors.put(key, error);
    }
}

