/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.util;

public class RADecConverter {
    private static double getRad(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static double getRadiusRadians(double radius) {
        return RADecConverter.getRad(radius / 60.0);
    }

    public static Double getRARadians(String ra) {
        if (ra == null) {
            return null;
        }
        return RA.parse(ra).getRadians();
    }

    public static Double getRADegrees(String ra) {
        if (ra == null) {
            return null;
        }
        return RA.parse(ra).getDegrees();
    }

    public static Double getDecRadians(String dec) {
        if (dec == null) {
            return null;
        }
        return Dec.parse(dec).getRadians();
    }

    public static Double getDecDegrees(String dec) {
        if (dec == null) {
            return null;
        }
        return Dec.parse(dec).getDegrees();
    }

    private static class RA {
        private final double hours;
        private final double minutes;
        private final double seconds;

        private RA(String ra) {
            String[] splitRA = ra.split(":");
            if (splitRA.length != 3) {
                throw new IllegalArgumentException(ra + " is not a valid RA format");
            }
            try {
                this.hours = Integer.parseInt(splitRA[0]);
                this.minutes = Integer.parseInt(splitRA[1]);
                this.seconds = Double.parseDouble(splitRA[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(ra + " is not a valid RA format");
            }
        }

        double getRadians() {
            return RADecConverter.getRad(this.getDegrees());
        }

        double getDegrees() {
            return (this.hours + this.minutes / 60.0 + this.seconds / 3600.0) * 15.0;
        }

        static RA parse(String ra) {
            return new RA(ra);
        }
    }

    private static class Dec {
        private byte sign;
        private final double deg;
        private final double minutes;
        private final double seconds;

        private Dec(String dec) {
            String[] splitDec = dec.split(":");
            if (splitDec.length != 3) {
                throw new IllegalArgumentException(dec + " is not a valid Dec format");
            }
            String degStr = splitDec[0];
            this.sign = 1;
            if (degStr.charAt(0) == '-') {
                this.sign = (byte)-1;
                degStr = degStr.substring(1);
            }
            try {
                this.deg = Integer.parseInt(degStr);
                this.minutes = Integer.parseInt(splitDec[1]);
                this.seconds = Double.parseDouble(splitDec[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(dec + " is not a valid Dec format");
            }
        }

        double getRadians() {
            return RADecConverter.getRad(this.getDegrees());
        }

        double getDegrees() {
            return (double)this.sign * (this.deg + this.minutes / 60.0 + this.seconds / 3600.0);
        }

        static Dec parse(String dec) {
            return new Dec(dec);
        }
    }
}

