/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.executor;

import it.inaf.ia2.query.builder.QueryBuilder;
import it.inaf.ia2.query.conf.PortalConfig;
import it.inaf.ia2.query.exception.QueryExecutionException;
import it.inaf.ia2.tapclient.QueryResultsParser;
import it.inaf.ia2.tapclient.TAPClient;
import it.inaf.ia2.tapclient.TAPServiceException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

public class FilesListQueryExecutor {
    private final QueryBuilder filesListQueryBuilder;
    private final TAPClient tapClient;

    public FilesListQueryExecutor(PortalConfig portalConfig, TAPClient tapClient, QueryBuilder filesListQueryBuilder) {
        this.filesListQueryBuilder = filesListQueryBuilder;
        this.tapClient = tapClient;
    }

    public void execute(OutputStream out) {
        String query = this.filesListQueryBuilder.buildQuery().get();
        try (PrintWriter pw = new PrintWriter(out);){
            FilesListQueryResultsParser parser = new FilesListQueryResultsParser(this.tapClient, query, pw);
            try {
                parser.parseQuery();
            }
            catch (TAPServiceException e) {
                throw new QueryExecutionException(e, query);
            }
        }
    }

    private static class FilesListQueryResultsParser
    extends QueryResultsParser {
        private final PrintWriter pw;

        public FilesListQueryResultsParser(TAPClient client, String query, PrintWriter pw) {
            super(client, query);
            this.pw = pw;
        }

        public void readMetadataItem(Map<String, Object> rowItem) {
        }

        public void readDataRow(List<Object> rowItems) {
            if (rowItems.size() != 1) {
                throw new IllegalStateException("Files list query must return a single column, " + rowItems.size() + " found!");
            }
            this.pw.write((String)rowItems.get(0) + "\n");
        }
    }
}

