/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.executor;

import it.inaf.ia2.query.builder.ListQueryBuilder;
import it.inaf.ia2.query.builder.QueryBuilder;
import it.inaf.ia2.query.conf.PortalConfig;
import it.inaf.ia2.query.exception.QueryExecutionException;
import it.inaf.ia2.query.result.QueryResult;
import it.inaf.ia2.query.result.QueryResultBuilder;
import it.inaf.ia2.query.result.QueryResultBuilderComposite;
import it.inaf.ia2.query.result.QueryResultBuilderParams;
import it.inaf.ia2.query.result.QueryResultBuilderSimple;
import it.inaf.ia2.tapclient.TAPClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultQueryExecutor.class);
    private final ListQueryBuilder listQueryBuilder;
    private final QueryBuilder countQueryBuilder;
    private final PortalConfig portalConfig;
    private final TAPClient tapClient;

    public DefaultQueryExecutor(PortalConfig portalConfig, TAPClient tapClient, ListQueryBuilder listQueryBuilder, QueryBuilder countQueryBuilder) {
        this.listQueryBuilder = listQueryBuilder;
        this.countQueryBuilder = countQueryBuilder;
        this.portalConfig = portalConfig;
        this.tapClient = tapClient;
    }

    public QueryResult execute() {
        String listQuery = null;
        String countQuery = null;
        try {
            QueryResultBuilder resultBuilder;
            listQuery = this.listQueryBuilder.buildQuery().get();
            countQuery = this.countQueryBuilder.buildQuery().get();
            LOG.debug("List Query " + listQuery);
            LOG.debug("Count Query " + countQuery);
            List<String> outColumns = this.listQueryBuilder.getOutputColumns();
            QueryResultBuilderParams params = new QueryResultBuilderParams().setTapClient(this.tapClient).setQueryList(listQuery).setQueryCount(countQuery).setOutColumns(outColumns);
            switch (this.portalConfig.getRowFormat()) {
                case SIMPLE: {
                    resultBuilder = new QueryResultBuilderSimple(params);
                    break;
                }
                case COMPOSITE: {
                    resultBuilder = new QueryResultBuilderComposite(params, this.portalConfig.getRowspanColumns(), this.portalConfig.getCompositeRowIndexColumn());
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported row format " + this.portalConfig.getRowFormat());
                }
            }
            return resultBuilder.buildResult();
        }
        catch (Throwable t) {
            throw new QueryExecutionException(t, listQuery, countQuery);
        }
    }
}

