/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.builder;

import it.inaf.ia2.query.builder.QueryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQueryBuilder
implements QueryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(BaseQueryBuilder.class);
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(?:%|_)");
    private final Map<String, Object> params;
    private final List<String> selects;
    private final List<String> outputColumns;
    private final List<String> wheres;
    private final StringBuilder stringBuilder;
    private Map<String, List<String>> selectOrder;

    protected BaseQueryBuilder(Map<String, Object> params) {
        this.params = params;
        this.selects = new ArrayList<String>();
        this.outputColumns = new ArrayList<String>();
        this.wheres = new ArrayList<String>();
        this.stringBuilder = new StringBuilder();
    }

    public void setSelectOrder(Map<String, List<String>> selectOrder) {
        this.selectOrder = selectOrder;
    }

    @Override
    public abstract QueryBuilder buildQuery();

    @Override
    public final String get() {
        return this.stringBuilder.toString();
    }

    protected final BaseQueryBuilder append(Object value) {
        this.stringBuilder.append(value).append(" ");
        return this;
    }

    protected Object get(String key) {
        return this.params.get(key);
    }

    protected <T> T get(String key, Class<T> type) {
        return (T)this.get(key);
    }

    protected double getDouble(String key) {
        Object value = this.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        return Double.parseDouble((String)value);
    }

    protected boolean getBool(String key) {
        Boolean value = this.get(key, Boolean.class);
        if (value != null) {
            return value;
        }
        return false;
    }

    protected boolean has(String key) {
        return this.params.get(key) != null;
    }

    protected void appendList(List<String> values, String delimiter) {
        this.append(String.join((CharSequence)delimiter, values));
    }

    protected void conditionalAddToSelect(String columnName) {
        if (this.getBool(columnName + "_sel")) {
            this.addToSelect(columnName);
        }
    }

    protected void conditionalAddToSelect(String column, String columnAlias) {
        if (this.getBool(columnAlias + "_sel")) {
            this.addToSelect(column, columnAlias);
        }
    }

    protected void addToSelect(String columnName) {
        if (!this.outputColumns.contains(columnName)) {
            this.selects.add(columnName);
            this.outputColumns.add(columnName);
        }
    }

    protected void addToSelect(String column, String columnAlias) {
        if (!this.outputColumns.contains(columnAlias)) {
            this.selects.add(column + " AS " + columnAlias);
            this.outputColumns.add(columnAlias);
        }
    }

    protected void appendTopAndOffset() {
        if (this.has("top")) {
            this.append("TOP").append(this.get("top", Long.class));
            if (this.has("offset")) {
                this.append("OFFSET").append(this.get("offset", Long.class));
            }
        }
    }

    private Object getSafeParam(String key, Function paramTransf) {
        Object value = this.params.get(key);
        if (paramTransf != null) {
            value = paramTransf.apply(this.params.get(key));
        }
        if (value instanceof String) {
            String stringParam = this.sanitizeQuotes((String)value);
            return String.format("'%s'", stringParam);
        }
        return value;
    }

    private Object getSafeLikeParam(String key, String wildCardBefore, String wildCardAfter) {
        return this.getSafeLikeParam(key, wildCardBefore, wildCardAfter, null);
    }

    private Object getSafeLikeParam(String key, String wildCardBefore, String wildCardAfter, Function paramTransf) {
        Object value = this.params.get(key);
        if (paramTransf != null) {
            value = paramTransf.apply(this.params.get(key));
        }
        if (value instanceof String) {
            Object stringParam = this.sanitizeForLike((String)value);
            if (wildCardBefore != null) {
                stringParam = wildCardBefore + (String)stringParam;
            }
            if (wildCardAfter != null) {
                stringParam = (String)stringParam + wildCardAfter;
            }
            return String.format("'%s'", stringParam);
        }
        return value;
    }

    protected String sanitizeForLike(String input) {
        String sanitizedInput = this.sanitizeQuotes(input);
        sanitizedInput = this.sanitizeWildcards(sanitizedInput);
        return sanitizedInput;
    }

    protected String sanitizeQuotes(String input) {
        return input.replace("'", "''");
    }

    private String sanitizeWildcards(String input) {
        return WILDCARD_PATTERN.matcher(input).replaceAll("\\\\$0");
    }

    protected String getSafeParamList(List<String> values) {
        return values.stream().map(value -> String.format("'%s'", this.sanitizeQuotes((String)value))).collect(Collectors.joining(","));
    }

    protected void addCondition(String column, String operator, String key) {
        this.addCondition(column, operator, key, null);
    }

    protected void addCondition(String column, String operator, String key, Function paramTransf) {
        if (this.has(key)) {
            String whereCond = String.format("%s %s %s", column, operator, this.getSafeParam(key, paramTransf));
            this.wheres.add(whereCond);
        }
    }

    protected void addCondition(String colKey, String operator) {
        this.addCondition(colKey, operator, colKey, null);
    }

    protected void addCondition(String colKey, String operator, Function paramTransf) {
        this.addCondition(colKey, operator, colKey, paramTransf);
    }

    protected void addLikeCondition(String column, String key, boolean wildCardBefore, boolean wildCardAfter) {
        if (this.has(key)) {
            String whereCond = String.format("%s LIKE %s", column, this.getSafeLikeParam(key, wildCardBefore ? "%" : null, wildCardAfter ? "%" : null));
            this.wheres.add(whereCond);
        }
    }

    protected void addLikeCondition(String colKey, boolean wildCardBefore, boolean wildCardAfter) {
        this.addLikeCondition(colKey, colKey, wildCardBefore, wildCardAfter);
    }

    protected void addRangeCondition(String column, String key) {
        this.addRangeCondition(column, key, null);
    }

    protected void addRangeCondition(String column, String key, Function paramTransf) {
        this.addCondition(column, ">=", key + "_min", paramTransf);
        this.addCondition(column, "<=", key + "_max", paramTransf);
    }

    protected void addRangeCondition(String colKey) {
        this.addRangeCondition(colKey, colKey, null);
    }

    protected void addRangeCondition(String colKey, Function paramTransf) {
        this.addRangeCondition(colKey, colKey, paramTransf);
    }

    protected void appendSelectList() {
        this.sortSelectList();
        this.appendList(this.selects, ", ");
    }

    protected void sortSelectList() {
        if (this.selectOrder != null) {
            ArrayList<String> sortedSelects = new ArrayList<String>();
            ArrayList<String> sortedOutputColumns = new ArrayList<String>();
            this.addToSorted(sortedSelects, sortedOutputColumns);
            this.selects.clear();
            this.selects.addAll(sortedSelects);
            this.outputColumns.clear();
            this.outputColumns.addAll(sortedOutputColumns);
        }
    }

    private void addToSorted(List<String> sortedSelects, List<String> sortedOutputColumns) {
        String secondaryTab;
        this.addToSorted(sortedSelects, sortedOutputColumns, this.selectOrder.get("main"));
        String tab = (String)this.params.get("tab");
        if (tab != null) {
            this.addToSorted(sortedSelects, sortedOutputColumns, this.selectOrder.get(tab));
        }
        if ((secondaryTab = (String)this.params.get("secondary_tab")) != null) {
            this.addToSorted(sortedSelects, sortedOutputColumns, this.selectOrder.get(secondaryTab));
        }
        if (sortedSelects.size() != this.selects.size()) {
            for (String value : this.selects) {
                if (sortedSelects.contains(value)) continue;
                LOG.debug("key {} not found in sorted_select.txt", (Object)value);
                sortedSelects.add(value);
                sortedOutputColumns.add(this.outputColumns.get(this.selects.indexOf(value)));
            }
        }
    }

    private void addToSorted(List<String> sortedSelects, List<String> sortdOutputColumns, List<String> formPartList) {
        if (formPartList != null) {
            for (String key : formPartList) {
                String value = this.getStringEndingWith(this.selects, "AS " + key);
                if (value == null || sortdOutputColumns.contains(key)) continue;
                sortedSelects.add(value);
                sortdOutputColumns.add(key);
            }
        }
    }

    private String getStringEndingWith(List<String> values, String value) {
        for (String val : values) {
            if (!val.endsWith(value)) continue;
            return val;
        }
        return null;
    }

    protected void addToWhere(String whereCond) {
        this.wheres.add(whereCond);
    }

    protected void appendWhere() {
        if (!this.wheres.isEmpty()) {
            this.append("WHERE");
            this.appendList(this.wheres, " AND ");
        }
    }

    protected void appendSort() {
        List sortInfos;
        ArrayList<String> sorts = new ArrayList<String>();
        if (this.has("sort") && (sortInfos = this.get("sort", List.class)) != null && !sortInfos.isEmpty()) {
            sortInfos.forEach(sortInfo -> sorts.add(String.format("%s %s", sortInfo.getColumnName(), sortInfo.getSort())));
            this.append("ORDER BY");
            this.appendList(sorts, ", ");
        }
    }

    public List<String> getOutputColumns() {
        return this.outputColumns;
    }

    protected Map<String, Object> getParams() {
        return this.params;
    }
}

