/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.prisma;

import it.inaf.ia2.query.builder.BaseQueryBuilder;
import it.inaf.ia2.query.builder.ListQueryBuilder;
import it.inaf.ia2.query.prisma.PrismaQueryBuilder;
import java.util.Map;

public class PrismaListQueryBuilder
extends PrismaQueryBuilder
implements ListQueryBuilder {
    public PrismaListQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    public BaseQueryBuilder buildQuery() {
        this.append("SELECT");
        this.appendTopAndOffset();
        this.appendSelectList();
        this.appendCommonQueryPart();
        this.appendSort();
        return this;
    }

    protected void appendSelectList() {
        boolean isAdmin = this.isAdmin();
        this.addToSelect("'" + (isAdmin ? "PRIV" : "FREE") + "'", "policy");
        if (this.isAdmin()) {
            this.addToSelect(this.getFileNameCol(), "file_name");
            this.addToSelect("'PRISMA'", "program");
        } else {
            this.addToSelect(this.getPreviewFileNameCol(), "file_name");
        }
        this.addToSelect(isAdmin ? "URL" : "URL_PRE", "file_url");
        this.addToSelect("URL_PRE", "preview_url");
        if (this.has("event_name_sel") && this.getBool("event_name_sel")) {
            this.addToSelect("w1.event_name", "event_name");
        }
        if (this.getBool("station_sel")) {
            this.addToSelect(this.getStationCol(), "station");
        }
        if (this.getBool("obs_mode_sel")) {
            this.addToSelect(this.getObsModeCol(), "obs_mode");
        }
        if (this.getBool("date_obs_sel")) {
            this.addToSelect(this.getDateObsCol(), "date_obs");
        }
        if (this.getBool("sitelong_sel")) {
            this.addToSelect(this.getSiteLongCol(), "sitelong");
        }
        if (this.getBool("sitelat_sel")) {
            this.addToSelect(this.getSiteLatCol(), "sitelat");
        }
        if (this.getBool("siteelev_sel")) {
            this.addToSelect(this.getSiteElevCol(), "siteelev");
        }
        super.appendSelectList();
    }

    private boolean isAdmin() {
        if (this.has("PRISMA_ADMIN")) {
            return this.getBool("PRISMA_ADMIN");
        }
        return false;
    }
}

