/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.prisma;

import it.inaf.ia2.query.builder.BaseQueryBuilder;
import it.inaf.ia2.query.prisma.Tab;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public abstract class PrismaQueryBuilder
extends BaseQueryBuilder {
    public PrismaQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    protected void appendCommonQueryPart() {
        this.appendFrom();
        this.appendJoins();
        this.appendWhere();
    }

    protected void appendFrom() {
        if (Tab.EVENTS.equals((Object)this.getTab())) {
            this.append("FROM prisma.web_2 w2");
        } else {
            this.append("FROM prisma_calib.PRS captures");
        }
    }

    protected void appendJoins() {
        if (Tab.EVENTS.equals((Object)this.getTab())) {
            this.append("JOIN (\n");
            this.append("SELECT file_name f, MAX(file_version) v FROM prisma.web_2 GROUP BY f\n");
            this.append(") AS j ON w2.file_name = j.f AND w2.file_version = j.v");
            this.append("JOIN prisma.web_1 w1 ON w1.file_info_id = w2.file_info_id");
            if (this.isMultipleMode()) {
                this.append("JOIN prisma.web_1 ew1 ON w1.event_name = ew1.event_name");
            }
        }
    }

    protected Tab getTab() {
        String tab;
        switch (tab = (String)this.get("tab", String.class)) {
            case "events": {
                return Tab.EVENTS;
            }
            case "calib": {
                return Tab.CAPTURES;
            }
        }
        throw new UnsupportedOperationException("Invalid tab: " + tab);
    }

    protected void appendWhere() {
        this.addLikeCondition(this.getFileNameCol(), "file_name", false, true);
        this.addLikeCondition("w1.event_name", "event_name", false, true);
        this.addCondition(this.getStationCol(), "=", "station");
        this.addCondition(this.getObsModeCol(), "=", "obs_mode");
        this.addRangeCondition(this.getDateObsCol(), "date_obs", date -> this.formatDate(date).trim().replace(" ", "T"));
        this.addRangeCondition(this.getSiteLongCol(), "sitelong");
        this.addRangeCondition(this.getSiteLatCol(), "sitelat");
        this.addRangeCondition(this.getSiteElevCol(), "siteelev");
        super.appendWhere();
    }

    private String formatDate(Object dateObj) {
        Date date = dateObj instanceof Date ? (Date)dateObj : this.getDate(dateObj);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.s");
        return sdf.format(date);
    }

    private Date getDate(Object date) {
        if (date instanceof Date) {
            return (Date)date;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            return sdf.parse((String)date);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getColByTab(String eventsColumn, String calibColumn) {
        return Tab.EVENTS.equals((Object)this.getTab()) ? eventsColumn : calibColumn;
    }

    protected String getFileNameCol() {
        return this.getColByTab("w2.file_name", "file_name");
    }

    protected String getPreviewFileNameCol() {
        return this.getColByTab("w2.PREVIEW_FILE_NAME", "PREVIEW_FILE_NAME");
    }

    protected String getStationCol() {
        return this.getColByTab(this.isMultipleMode() ? "ew1.station" : "w1.station", "TELESCOP");
    }

    protected String getObsModeCol() {
        return this.getColByTab("w1.obs_mode", "OBS_MODE");
    }

    protected String getDateObsCol() {
        return this.getColByTab("w1.date_obs", "DATE_OBS");
    }

    protected String getSiteLongCol() {
        return this.getColByTab("w1.sitelong", "SITELONG");
    }

    protected String getSiteLatCol() {
        return this.getColByTab("w1.sitelat", "SITELAT");
    }

    protected String getSiteElevCol() {
        return this.getColByTab("w1.siteelev", "SITEELEV");
    }

    private boolean isMultipleMode() {
        return Tab.EVENTS.equals((Object)this.getTab()) && this.has("multiple_mode") && this.getBool("multiple_mode");
    }
}

