/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.mince;

import it.inaf.ia2.query.builder.DefaultQueryBuilder;
import it.inaf.ia2.query.util.RADecConverter;
import java.util.List;
import java.util.Map;

public abstract class MinceQueryBuilder
extends DefaultQueryBuilder {
    private static final List<String> MINCE_KEYWORDS_TO_IGNORE = MinceQueryBuilder.createKeywordsToIgnoreList((String[])new String[]{"ra_sel", "dec_sel", "abundances_sel", "abundances_min", "abundances_max", "abundances"});

    public MinceQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    protected List<String> getKeywordsToIgnore() {
        return MINCE_KEYWORDS_TO_IGNORE;
    }

    protected void appendWhere() {
        this.appendPositionalSearch();
        this.appendAbundancesSearch();
        super.appendWhere();
    }

    private void appendAbundancesSearch() {
        if (this.has("abundances") && this.has("abundances_min") && this.has("abundances_max")) {
            String fullColumnName = (String)this.get("abundances", String.class);
            this.addCondition(fullColumnName, ">=", "abundances_min");
            this.addCondition(fullColumnName, "<=", "abundances_max");
        }
    }

    private void appendPositionalSearch() {
        if (this.has("ra") && this.has("dec") && this.has("radius")) {
            double ra = RADecConverter.getRADegrees((String)((String)this.get("ra", String.class)));
            double dec = RADecConverter.getDecDegrees((String)((String)this.get("dec", String.class)));
            double radius = this.getDouble("radius") / 60.0;
            this.addToWhere(String.format("(\"%s\".\"%s\" BETWEEN %s AND %s) AND (\"%s\".\"%s\" BETWEEN %s AND %s)", "mince", "RAdeg", ra - radius, ra + radius, "mince", "DEdeg", dec - radius, dec + radius));
        }
    }
}

