/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.lbt;

import it.inaf.ia2.query.builder.DefaultQueryBuilder;
import it.inaf.ia2.query.lbt.Tab;
import it.inaf.ia2.query.util.RADecConverter;
import it.inaf.ia2.tapclient.TAPServiceException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LBTQueryBuilder
extends DefaultQueryBuilder {
    private static final List<String> LBT_KEYWORDS_TO_IGNORE = LBTQueryBuilder.createKeywordsToIgnoreList((String[])new String[]{"single_night", "ra_sel", "dec_sel", "short_program_sel", "date_obs", "date_obs_min", "date_obs_max", "mask", "mask_sel", "masktype", "roi_sel", "roi", "ccdxybin_sel", "ccdxybin"});
    private static final Map<String, String> LUCI_OLD_MASKS = new HashMap<String, String>();
    private final Set<String> mainGridColumns = new HashSet<String>(Arrays.asList("file_name", "policy", "short_program", "date_obs", "exptime", "flt_id", "instrument", "object", "imagetyp", "piname", "partner"));

    public LBTQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    protected void appendWhere() {
        String partner;
        this.addLikeCondition("lbt.file_name", "file_name", true, true);
        this.addLikeCondition("lbt.instrument", "instrument", false, true);
        this.addLikeCondition("lbt.piname", "piname", true, true);
        this.addLikeCondition("lbt.partner", "partner", true, true);
        String object = (String)this.get("object", String.class);
        if (object != null && !object.isBlank()) {
            this.addUsedKey("object");
            String param = this.sanitizeForLike(object);
            this.addToWhere("(lbt.object LIKE '%" + param + "%' OR lbt.objname LIKE '%" + param + "%')");
        }
        if ((partner = (String)this.get("partner", String.class)) != null && !partner.isBlank() && partner.equals("CALIBRATION")) {
            this.addUsedKey("partner");
            String param = this.sanitizeForLike(partner);
            this.addToWhere("(lbt.partner LIKE '%" + param + "%' OR lbt.partner LIKE '%LBTB,INAF,OSURC,AZ,LBTO%')");
        }
        if (Tab.MODS == this.getTab()) {
            this.addLikeCondition("mods.imagetyp", "imagetyp", false, true);
        } else if (Tab.LBC == this.getTab()) {
            this.addLikeCondition("lbc.imagetyp", "imagetyp", false, true);
        } else {
            this.addLikeCondition("lbt.imagetyp", "imagetyp", false, true);
        }
        this.addLikeCondition("lbt.program", "short_program", false, true);
        if (Tab.LBC == this.getTab()) {
            this.addLikeCondition("lbc.flt_id", "flt_id", false, true);
        } else {
            this.addLikeCondition("lbt.flt_id", "flt_id", true, true);
        }
        if (Tab.LBC == this.getTab()) {
            this.addLikeCondition("lbc.objname", "objname", false, false);
            this.addLikeCondition("lbc.propid", "propid", false, false);
            this.addLikeCondition("lbc.obid", "obid", false, false);
            this.addLikeCondition("lbc.obname", "obname", false, false);
        }
        if (Tab.LUCI == this.getTab()) {
            this.addLikeCondition("luci.camera", "camera", false, false);
            this.addLikeCondition("luci.maskslot", "maskslot", false, false);
            this.addLikeCondition("luci.gratwlen", "gratwlen", false, false);
            this.addLikeCondition("luci.gratvolt", "gratvolt", false, false);
            this.addLikeCondition("luci.gratorde", "gratorde", false, false);
            this.addLikeCondition("luci.optic", "optic", false, false);
            this.addLikeCondition("luci.mospos", "mospos", false, false);
            this.handleLuciGratname();
            this.handleLuciMask();
        }
        if (Tab.MODS == this.getTab()) {
            this.addLikeCondition("\"mods\".objname", "objname", false, false);
            this.handleModsMask();
            this.handleModsGratName();
            this.handleModsRoi();
            this.handleModsCcdXYBin();
        }
        if (Tab.IRT == this.getTab()) {
            this.addLikeCondition("irt.mode", "mode", false, false);
            this.addLikeCondition("irt.instruml", "instruml", false, false);
            this.addLikeCondition("irt.instrumr", "instrumr", false, false);
        }
        if (Tab.PIS == this.getTab()) {
            this.addLikeCondition("pis.flt_id", "flt_id", false, false);
            this.addLikeCondition("pis.obs_mode", "obs_mode", false, false);
        }
        this.addDateCondition();
        this.appendPositionalSearch();
        this.appendGroupsCondition();
        super.appendWhere();
    }

    private void handleLuciGratname() {
        if (this.has("gratname")) {
            String gratname;
            switch (gratname = (String)this.get("gratname", String.class)) {
                case "G210 HiRes": {
                    this.addUsedKey("gratname");
                    this.addToWhere("(luci.gratname = 'G210 HiRes' OR luci.gratname = '210 zJHK')");
                    break;
                }
                case "G200 LoRes": {
                    this.addUsedKey("gratname");
                    this.addToWhere("(luci.gratname = 'G200 LoRes' OR luci.gratname = '200 H+K')");
                    break;
                }
                case "G150 Ks": {
                    this.addUsedKey("gratname");
                    this.addToWhere("(luci.gratname = 'G150 Ks' OR luci.gratname = '150 Ks')");
                    break;
                }
                default: {
                    this.addLikeCondition("luci.gratname", "gratname", true, true);
                }
            }
        }
    }

    private void handleLuciMask() {
        if (this.has("mask")) {
            String param = this.sanitizeForLike((String)this.get("mask", String.class));
            ArrayList<String> orConditions = new ArrayList<String>();
            this.addLuciMaskOrConditions(orConditions, param);
            String oldName = LUCI_OLD_MASKS.get(param);
            if (oldName != null) {
                this.addLuciMaskOrConditions(orConditions, oldName);
            }
            this.addToWhere("(" + String.join((CharSequence)" OR ", orConditions) + ")");
        }
    }

    private void addLuciMaskOrConditions(List<String> orConditions, String param) {
        orConditions.add("luci.maskid LIKE '%" + param + "%'");
        orConditions.add("luci.maskname LIKE '%" + param + "%'");
    }

    private void handleModsGratName() {
        if (this.has("gratname")) {
            String gratname;
            switch (gratname = (String)this.get("gratname", String.class)) {
                case "grating": {
                    this.addUsedKey("gratname");
                    this.addToWhere("(mods.gratname = 'G400L' OR mods.gratname = 'G670L')");
                    break;
                }
                case "prism": {
                    this.addUsedKey("gratname");
                    this.addToWhere("(mods.gratname = 'P450L' OR mods.gratname = 'P700L')");
                    break;
                }
                default: {
                    this.addLikeCondition("mods.gratname", "gratname", false, false);
                }
            }
        }
    }

    private void handleModsRoi() {
        if (this.has("roi")) {
            String roi = (String)this.get("roi", String.class);
            this.addUsedKey("roi");
            switch (roi) {
                case "8K x 3K": {
                    this.addToWhere("mods.ccdroi = '[1:8288,1:3088]'");
                    break;
                }
                case "4K x 3K": {
                    this.addToWhere("mods.ccdroi = '[2097:6192,1:3088]'");
                    break;
                }
                case "3K x 3K": {
                    this.addToWhere("mods.ccdroi = '[2601:5688,1:3088]'");
                    break;
                }
                case "1K x 1K": {
                    this.addToWhere("mods.ccdroi = '[3633:4656,1033:2056]'");
                    break;
                }
                default: {
                    throw new TAPServiceException("Unsupported ROI value: " + roi);
                }
            }
        }
    }

    private void handleModsCcdXYBin() {
        if (this.has("ccdxybin")) {
            String ccdxybin = (String)this.get("ccdxybin", String.class);
            this.addUsedKey("ccdxybin");
            switch (ccdxybin) {
                case "1 x 1": {
                    this.addToWhere("(ccdxbin = 1 and ccdybin = 1)");
                    break;
                }
                case "1 x 2": {
                    this.addToWhere("(ccdxbin = 1 and ccdybin = 2)");
                    break;
                }
                case "2 x 1": {
                    this.addToWhere("(ccdxbin = 2 and ccdybin = 1)");
                    break;
                }
                case "2 x 2": {
                    this.addToWhere("(ccdxbin = 2 and ccdybin = 2)");
                    break;
                }
                default: {
                    throw new TAPServiceException("Unsupported XBIN x YBIN value: " + ccdxybin);
                }
            }
        }
    }

    private void handleModsMask() {
        if (this.has("maskid") && "custom".equals(this.get("masktype", String.class))) {
            this.addLikeCondition("\"mods\".maskid", "maskid", true, true);
        }
    }

    private void addDateCondition() {
        if (this.singleNight()) {
            this.addCondition("lbt.date_obs", ">=", "date_obs", date -> this.formatDate(this.setNoon(date)));
            this.addCondition("lbt.date_obs", "<=", "date_obs", date -> this.formatDate(this.addDay(this.setNoon(date))));
        } else {
            this.addCondition("lbt.date_obs", ">=", "date_obs_min", this::formatDate);
            this.addCondition("lbt.date_obs", "<=", "date_obs_max", this::formatDate);
        }
    }

    private String formatDate(Object date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.s");
        return sdf.format(date);
    }

    private Date addDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 1);
        return calendar.getTime();
    }

    private Date setNoon(Object date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.getDate(date));
        calendar.set(11, 12);
        return calendar.getTime();
    }

    private Date getDate(Object date) {
        if (date instanceof Date) {
            return (Date)date;
        }
        try {
            String dateFormat = this.singleNight() ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm";
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            return sdf.parse((String)date);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean singleNight() {
        return this.has("single_night") && this.getBool("single_night");
    }

    private void appendPositionalSearch() {
        if (this.has("ra") && this.has("dec") && this.has("radius")) {
            double ra = RADecConverter.getRADegrees((String)((String)this.get("ra", String.class)));
            double dec = RADecConverter.getDecDegrees((String)((String)this.get("dec", String.class)));
            double radius = this.getDouble("radius") / 60.0;
            this.addToWhere("s_point IS NOT NULL AND 1=CONTAINS(s_point, CIRCLE('ICRS'," + ra + "," + dec + "," + radius + "))");
        }
    }

    private void appendGroupsCondition() {
        if (this.has("user_groups") && !this.has("program")) {
            List groups = (List)this.get("user_groups", List.class);
            ArrayList<String> parentGroups = new ArrayList<String>();
            ArrayList<String> programs = new ArrayList<String>();
            for (String group : groups) {
                if (group.contains(".")) {
                    programs.add(group.substring(group.indexOf(".") + 1));
                    continue;
                }
                parentGroups.add(group);
            }
            if (!programs.isEmpty() && !parentGroups.isEmpty()) {
                this.addToWhere("(lbt.parent_group IN(" + this.getSafeParamList(parentGroups) + ") OR lbt.program IN(" + this.getSafeParamList(programs) + "))");
            } else if (!programs.isEmpty()) {
                this.addToWhere("lbt.program IN(" + this.getSafeParamList(programs) + ")");
            } else if (!parentGroups.isEmpty()) {
                this.addToWhere("lbt.parent_group IN(" + this.getSafeParamList(parentGroups) + ")");
            }
        }
    }

    protected String getFullColumnName(String columnKey) {
        Tab tab = this.getTab();
        if (Tab.LBC == tab && "flt_id".equals(columnKey)) {
            return "lbc.flt_id";
        }
        if (this.mainGridColumns.contains(columnKey)) {
            return "lbt.\"" + columnKey + "\"";
        }
        if (tab == null) {
            throw new IllegalStateException("Unable to find a table for the column " + columnKey);
        }
        return "\"" + tab + "\".\"" + columnKey + "\"";
    }

    protected List<String> getKeywordsToIgnore() {
        return LBT_KEYWORDS_TO_IGNORE;
    }

    public void appendJoins() {
        Tab tab = this.getTab();
        if (tab != null) {
            this.append(String.format("JOIN lbt.\"%s\" \"%s\" ON lbt.file_name = \"%s\".file_name", new Object[]{tab, tab, tab}));
        }
    }

    protected Tab getTab() {
        String tab = (String)this.get("secondary_tab", String.class);
        if (tab == null) {
            return null;
        }
        return Tab.parse(tab);
    }

    static {
        LUCI_OLD_MASKS.put("LS\\_0.25arcsec", "LS0.25\\_150um");
        LUCI_OLD_MASKS.put("LS\\_0.50arcsec", "LS0.50\\_300um");
        LUCI_OLD_MASKS.put("LS\\_0.75arcsec", "LS0.75\\_450um");
        LUCI_OLD_MASKS.put("LS\\_1.00arcsec", "LS1.00\\_600um");
        LUCI_OLD_MASKS.put("LS\\_1.50arcsec", "LS1.50\\_900um");
        LUCI_OLD_MASKS.put("LS\\_2.00arcsec", "LS2.00\\_1200um");
    }
}

