/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.lbt;

import it.inaf.ia2.query.builder.ListQueryBuilder;
import it.inaf.ia2.query.builder.QueryBuilder;
import it.inaf.ia2.query.lbt.LBTQueryBuilder;
import it.inaf.ia2.query.lbt.Tab;
import java.util.Map;

public class LBTListQueryBuilder
extends LBTQueryBuilder
implements ListQueryBuilder {
    public LBTListQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    public QueryBuilder buildQuery() {
        this.append("SELECT");
        this.appendTopAndOffset();
        this.addDefaultSelects();
        this.addSpecialSelects();
        this.addSkyPosition();
        this.appendSelectList();
        this.append("FROM lbt.lbt lbt");
        this.appendJoins();
        this.appendWhere();
        this.appendSort();
        return this;
    }

    private void addDefaultSelects() {
        this.addToSelect("lbt.file_name", "file_name");
        this.addToSelect("lbt.file_url", "file_url");
        this.addToSelect("get_full_program(lbt.parent_group, lbt.program)", "program");
        this.conditionalAddToSelect("lbt.program", "short_program");
        this.addToSelect("lbt.policy", "policy");
    }

    private void addSpecialSelects() {
        if (Tab.LUCI == this.getTab() && this.has("mask_sel") && this.getBool("mask_sel")) {
            this.addToSelect("luci.maskid", "maskid");
            this.addToSelect("luci.maskname", "maskname");
        }
        if (Tab.MODS == this.getTab()) {
            this.conditionalAddToSelect("mods.imagetyp", "imagetyp");
            this.conditionalAddToSelect("get_roi(mods.ccdroi)", "roi");
            this.conditionalAddToSelect("ccdxbin || ' x ' || ccdybin", "ccdxybin");
        }
        if (Tab.LBC == this.getTab()) {
            this.conditionalAddToSelect("lbc.imagetyp", "imagetyp");
        }
    }

    private void addSkyPosition() {
        if (this.getBool("ra_sel")) {
            this.addToSelect("lbt.ra", "ra");
        }
        if (this.getBool("dec_sel")) {
            this.addToSelect("lbt.dec", "dec");
        }
    }
}

