/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.aao;

import it.inaf.ia2.query.builder.DefaultQueryBuilder;
import it.inaf.ia2.query.util.RADecConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AsiagoQueryBuilder
extends DefaultQueryBuilder {
    private static final List<String> AAO_KEYWORDS_TO_IGNORE = AsiagoQueryBuilder.createKeywordsToIgnoreList((String[])new String[]{"single_night", "ra_sel", "dec_sel", "program_sel", "DATE_OBS", "DATE_OBS_min", "DATE_OBS_max"});
    private final Set<String> mainGridColumns = new HashSet<String>(Arrays.asList("PROGRAM", "DATE_OBS", "EXP_TIME", "FLT", "DETECTOR", "INSTRUMENT", "OBJECT", "OBS_MODE", "OBSERVER"));

    public AsiagoQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    private String formatDate(Object dateObj) {
        Date date = dateObj instanceof Date ? (Date)dateObj : this.getDate(dateObj);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.s");
        return sdf.format(date);
    }

    private Date addDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 1);
        return calendar.getTime();
    }

    private Date setNoon(Object date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.getDate(date));
        calendar.set(11, 12);
        return calendar.getTime();
    }

    private Date getDate(Object date) {
        if (date instanceof Date) {
            return (Date)date;
        }
        try {
            String dateFormat = this.singleNight() ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm";
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            return sdf.parse((String)date);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void appendWhere() {
        this.addLikeCondition("aao.file_name", "file_name", true, true);
        this.addLikeCondition("aao.INSTRUMENT", "INSTRUMENT", false, true);
        this.addDateCondition();
        this.appendPositionalSearch();
        this.appendTabCondition();
        this.appendGroupsCondition();
        super.appendWhere();
    }

    private void addDateCondition() {
        if (this.singleNight()) {
            this.addCondition("aao.DATE_OBS", ">=", "DATE_OBS", date -> this.formatDate(this.setNoon(date)));
            this.addCondition("aao.DATE_OBS", "<=", "DATE_OBS", date -> this.formatDate(this.addDay(this.setNoon(date))));
        } else {
            this.addCondition("aao.DATE_OBS", ">=", "DATE_OBS_min", this::formatDate);
            this.addCondition("aao.DATE_OBS", "<=", "DATE_OBS_max", this::formatDate);
        }
    }

    private boolean singleNight() {
        return this.has("single_night") && this.getBool("single_night");
    }

    private void appendPositionalSearch() {
        if (this.has("ra") && this.has("dec") && this.has("radius")) {
            double ra = RADecConverter.getRADegrees((String)((String)this.get("ra", String.class)));
            double dec = RADecConverter.getDecDegrees((String)((String)this.get("dec", String.class)));
            double radius = this.getDouble("radius") / 60.0;
            this.addToWhere("s_point IS NOT NULL AND 1=CONTAINS(s_point, CIRCLE('ICRS'," + ra + "," + dec + "," + radius + "))");
        }
    }

    private void appendTabCondition() {
        if (this.has("secondary_tab") && "afo".equals(this.get("secondary_tab", String.class))) {
            this.addLikeCondition("AFO.HA", "HA", false, true);
            this.addLikeCondition("AFO.SLIT", "SLIT", false, false);
            this.addLikeCondition("AFO.LAMP", "LAMP", false, false);
        }
    }

    private void appendGroupsCondition() {
        List groups;
        if (this.has("user_groups") && !this.has("PROGRAM") && !(groups = (List)this.get("user_groups", List.class)).isEmpty()) {
            this.addToWhere("aao.PROGRAM IN(" + this.getSafeParamList(groups) + ")");
        }
    }

    protected String getFullColumnName(String columnKey) {
        if ("program".equals(columnKey)) {
            return "aao.PROGRAM";
        }
        if (this.mainGridColumns.contains(columnKey)) {
            return "aao." + columnKey;
        }
        String tab = (String)this.get("secondary_tab", String.class);
        if (tab == null) {
            throw new IllegalStateException("Unable to find a table for the column " + columnKey);
        }
        return tab + "." + columnKey;
    }

    protected List<String> getKeywordsToIgnore() {
        return AAO_KEYWORDS_TO_IGNORE;
    }

    public void appendJoins() {
        if (this.has("secondary_tab")) {
            switch ((String)this.get("secondary_tab", String.class)) {
                case "afo": {
                    this.append("JOIN aao.AFO afo ON aao.file_name = afo.file_name");
                    break;
                }
                case "ech": {
                    this.append("JOIN aao.ECH ech ON aao.file_name = ech.file_name");
                    break;
                }
                case "sbi": {
                    this.append("JOIN aao.SBI sbi ON aao.file_name = sbi.file_name");
                }
            }
        }
    }
}

